# LocalGhost Logo Pack

## Contents

### Icon (Ghost Mark)

**SVG (Vector)**
- `icon-transparent.svg` - Ghost icon, transparent background
- `icon-dark.svg` - Ghost icon, #111111 background

**PNG (Raster)**
- `icon-64.png` / `icon-dark-64.png` - 64×64px
- `icon-128.png` / `icon-dark-128.png` - 128×128px  
- `icon-256.png` / `icon-dark-256.png` - 256×256px
- `icon-512.png` / `icon-dark-512.png` - 512×512px

### Full Logo (Stacked)
- `logo-full-transparent.svg` / `logo-full-dark.svg` - Vector
- `logo-full-1100.png` / `logo-full-dark-1100.png` - 1100×500px

### Horizontal Logo
- `logo-horizontal-transparent.svg` / `logo-horizontal-dark.svg` - Vector
- `logo-horizontal-800.png` / `logo-horizontal-dark-800.png` - 800×160px

### Wordmark
- `wordmark-transparent.svg` / `wordmark-dark.svg` - Vector
- `wordmark-800.png` / `wordmark-dark-800.png` - 800×120px

---

## Color Specifications

| Name | Hex | Usage |
|------|-----|-------|
| Terminal Green | `#33FF00` | Primary brand color |
| The Void | `#111111` | Background color |

---

## Converting SVGs to Other Sizes

Need a different size? SVGs can be converted to PNG at any resolution:

### Using Inkscape (recommended)
```bash
inkscape icon-transparent.svg -w 1024 -h 1024 -o icon-1024.png
```

### Using rsvg-convert
```bash
rsvg-convert -w 1024 -h 1024 icon-transparent.svg -o icon-1024.png
```

### Using ImageMagick
```bash
convert -background none -resize 1024x1024 icon-transparent.svg icon-1024.png
```

---

## Usage Guidelines

### Clear Space
Maintain padding equal to the height of the ghost's "eyes" around all edges.

### Minimum Size
- Icon: 32px minimum
- Horizontal logo: 120px width minimum
- Full logo: 200px width minimum

### Do
- Use on dark backgrounds (#111111 or darker)
- Maintain the terminal green (#33FF00) color
- Use transparent versions on dark backgrounds

### Don't
- Place on light backgrounds without the dark background version
- Alter the colors
- Stretch or distort
- Add effects (drop shadows, glows, gradients)
- Rotate

---

## File Formats

All source files are SVG (Scalable Vector Graphics). SVGs are:
- Infinitely scalable without quality loss
- Small file size
- Editable
- Web-ready

Convert to PNG only when vector format is not supported.

---

## Questions?

info@localghost.ai
